#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2025 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Crime O'Clock
# send your bug reports to bugs@dotslashplay.it
###

script_version=20251008.3

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='crime-o-clock'
GAME_NAME='Crime O’Clock'

ARCHIVE_BASE_0_NAME='setup_crime_oclock_1.3.2_(64bit)_(68484).exe'
ARCHIVE_BASE_0_MD5='5facc36de5b0de6c6fd7b616c0e8ec54'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='1691934'
ARCHIVE_BASE_0_VERSION='1.3.2-gog68484'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/crime_oclock'

UNITY3D_NAME="crime o'clock"

CONTENT_PATH_DEFAULT='.'
## The game crashes on launch if steam_api64 library is not included
## and steam_api64.dll is linked against Galaxy64.dll.
CONTENT_GAME0_BIN_FILES='
galaxy64.dll'

WINE_PERSISTENT_DIRECTORIES="
users/\${USER}/AppData/LocalLow/Bad Seed SRL/Crime O'Clock"

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers.

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up temporary files.

working_directory_cleanup

exit 0
