"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.inPlaceRectifyFont = inPlaceRectifyFont;
const Ot = require("@ot-builder/ot");
const encoding_1 = require("../encoding");
const glyph_1 = require("../glyph");
const cff_1 = require("../glyph-store/cff");
const cvt_1 = require("../glyph-store/cvt");
const base_1 = require("../layout/base");
const gdef_1 = require("../layout/gdef");
const gsub_gpos_1 = require("../layout/gsub-gpos");
const math_1 = require("../layout/math");
const avar_1 = require("../meta/avar");
const fvar_1 = require("../meta/fvar");
const gasp_1 = require("../meta/gasp");
const hhea_vhea_1 = require("../meta/hhea-vhea");
const os2_1 = require("../meta/os2");
const post_1 = require("../meta/post");
const vtt_1 = require("../private/vtt");
function inPlaceRectifyFont(recGlyphRef, recAxes, recCoord, recPA, font) {
    rectifyFontMetadata(recAxes, recCoord, font);
    rectifyCmap(recGlyphRef, font);
    rectifyGlyphs(recGlyphRef, recCoord, recPA, font);
    rectifyCoGlyphs(recGlyphRef, recCoord, font);
    rectifyLayout(recGlyphRef, recAxes, recCoord, recPA, font);
    rectifyPrivate(recGlyphRef, font);
}
function rectifyCmap(recGlyphRef, font) {
    if (font.cmap) {
        font.cmap = (0, encoding_1.rectifyCmapTable)(recGlyphRef, font.cmap);
    }
    if (font.xPrv) {
        font.xPrv = (0, encoding_1.rectifyExtPrivateTable)(recGlyphRef, font.xPrv);
    }
}
function rectifyFontMetadata(recAxes, recCoord, font) {
    if (font.fvar)
        font.fvar = (0, fvar_1.rectifyFvarTable)(recAxes, font.fvar);
    if (font.avar)
        font.avar = (0, avar_1.rectifyAvarTable)(recAxes, font.avar);
    if (font.hhea)
        font.hhea = (0, hhea_vhea_1.rectifyHheaTable)(recCoord, font.hhea);
    if (font.vhea)
        font.vhea = (0, hhea_vhea_1.rectifyVheaTable)(recCoord, font.vhea);
    if (font.post)
        font.post = (0, post_1.rectifyPostTable)(recCoord, font.post);
    if (font.os2)
        font.os2 = (0, os2_1.rectifyOs2Table)(recCoord, font.os2);
    if (font.gasp)
        font.gasp = (0, gasp_1.rectifyGaspTable)(recCoord, font.gasp);
}
function rectifyGlyphs(recGlyphRef, recCoord, recPA, font) {
    (0, glyph_1.inPlaceRectifyGlyphStore)(recGlyphRef, recCoord, recPA, font.glyphs);
}
function rectifyCoGlyphs(recGlyphRef, recCoord, font) {
    if (Ot.Font.isCff(font)) {
        font.cff = (0, cff_1.rectifyCffTable)(recGlyphRef, recCoord, font.cff);
    }
    else {
        if (font.cvt)
            font.cvt = (0, cvt_1.rectifyCvtTable)(recCoord, font.cvt);
    }
}
function rectifyLayout(recGlyphRef, recAxes, recCoord, recPA, font) {
    if (font.gdef) {
        font.gdef = (0, gdef_1.rectifyGdefTable)(recGlyphRef, recCoord, recPA, font.gdef);
    }
    if (font.gsub) {
        font.gsub = (0, gsub_gpos_1.rectifyGsubTable)(recGlyphRef, recAxes, recCoord, recPA, font.gsub);
    }
    if (font.gpos) {
        font.gpos = (0, gsub_gpos_1.rectifyGposTable)(recGlyphRef, recAxes, recCoord, recPA, font.gpos);
    }
    if (font.base) {
        font.base = (0, base_1.rectifyBaseTable)(recGlyphRef, recCoord, recPA, font.base);
    }
    if (font.math) {
        font.math = (0, math_1.rectifyMathTable)(recGlyphRef, recCoord, font.math);
    }
}
function rectifyPrivate(recGlyphRef, font) {
    if (font.tsi01) {
        font.tsi01 = (0, vtt_1.rectifyTSI0123Table)(recGlyphRef, font.tsi01);
    }
    if (font.tsi23) {
        font.tsi23 = (0, vtt_1.rectifyTSI0123Table)(recGlyphRef, font.tsi23);
    }
    if (font.tsi5) {
        font.tsi5 = (0, vtt_1.rectifyTSI5Table)(recGlyphRef, font.tsi5);
    }
}
//# sourceMappingURL=rectify-font.js.map