"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MaxpStat = void 0;
class MaxpStat {
    constructor(maxp, outer) {
        this.maxp = maxp;
        this.outer = outer;
        // MAXP fields
        this.maxPoints = 0;
        this.maxContours = 0;
        this.maxCompositePoints = 0;
        this.maxCompositeContours = 0;
        this.maxSizeOfInstructions = 0;
        this.maxComponentElements = 0;
        this.maxComponentDepth = 0;
    }
    setNumGlyphs(count) {
        this.maxp.numGlyphs = count;
        if (this.outer)
            this.outer.setNumGlyphs(count);
    }
    setMetric(gid, horizontal, vertical, extent) {
        if (this.outer)
            this.outer.setMetric(gid, horizontal, vertical, extent);
    }
    simpleGlyphStat(st) {
        this.maxPoints = Math.max(this.maxPoints, st.eigenPoints);
        this.maxContours = Math.max(this.maxContours, st.eigenContours);
        this.maxComponentDepth = Math.max(this.maxComponentDepth, st.depth);
        if (this.outer)
            this.outer.simpleGlyphStat(st);
    }
    complexGlyphStat(st) {
        this.maxCompositePoints = Math.max(this.maxCompositePoints, st.totalPoints);
        this.maxCompositeContours = Math.max(this.maxCompositeContours, st.totalContours);
        this.maxComponentElements = Math.max(this.maxComponentElements, st.eigenReferences);
        this.maxComponentDepth = Math.max(this.maxComponentDepth, st.depth);
        if (this.outer)
            this.outer.complexGlyphStat(st);
    }
    instructionsStat(size) {
        this.maxSizeOfInstructions = Math.max(this.maxSizeOfInstructions, size);
        if (this.outer)
            this.outer.instructionsStat(size);
    }
    settle() {
        this.maxp.maxPoints = this.maxPoints;
        this.maxp.maxContours = this.maxContours;
        this.maxp.maxCompositePoints = this.maxCompositePoints;
        this.maxp.maxCompositeContours = this.maxCompositeContours;
        this.maxp.maxSizeOfInstructions = this.maxSizeOfInstructions;
        this.maxp.maxComponentElements = this.maxComponentElements;
        this.maxp.maxComponentDepth = this.maxComponentDepth;
        if (this.outer)
            this.outer.settle();
    }
}
exports.MaxpStat = MaxpStat;
//# sourceMappingURL=maxp.js.map