import { VarianceDim } from "../interface/dimension";
import { VarianceInstance, VarianceInstanceTupleW } from "../interface/instance";
import { VarianceMaster } from "../interface/master";
export type OtVarMasterDim = {
    readonly dim: VarianceDim;
    readonly min: number;
    readonly peak: number;
    readonly max: number;
};
export declare class OtVarMaster implements VarianceMaster<VarianceDim> {
    readonly regions: readonly OtVarMasterDim[];
    constructor(init: Iterable<null | undefined | OtVarMasterDim>);
    /**
     * Return the peak instance
     */
    getPeak(): VarianceInstanceTupleW<VarianceDim>;
    /**
     * Weight an instance under this master
     * If the master is invalid always return 0
     * @param instance instance to weight
     */
    evaluate(instance: VarianceInstance<VarianceDim>): number;
    /**
     * Whether a master is invalid.
     * OTVar says that every master must have 0 at origin (null instance)
     */
    isInvalid(): boolean;
    isSimple(): boolean;
    toString(): string;
}
//# sourceMappingURL=master.d.ts.map