"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Task = Task;
const interface_1 = require("../core/interface");
const rule_base_1 = require("./rule-base");
const util_1 = require("./util");
class TaskRule extends rule_base_1.RuleBase {
    constructor(matcher, FRecipe) {
        super(matcher);
        this.FRecipe = FRecipe;
        this.kindTag = "Builtin::TaskRule";
    }
    async build(t, ...args) {
        const result = await this.FRecipe(t, ...args);
        t.is.modified();
        return result;
    }
    async preBuild(t) {
        if (t.isVolatile)
            return interface_1.PreBuildResult.YES;
        return (await t.dependencyModified()) ? interface_1.PreBuildResult.YES : interface_1.PreBuildResult.TIME;
    }
    async shouldTriggerModify(t, itselfModified) {
        return itselfModified;
    }
}
function Task(dir) {
    const _task = (0, util_1.SinglePlural_T)("Builtin::Task::", dir, (matcher, FRecipe) => new TaskRule(matcher, FRecipe));
    return {
        task: Object.assign(_task.exact, {
            glob: _task.glob,
            group: _task.subPrefix,
            make: _task.make,
        }),
    };
}
