/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpitem_pdb.h
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#if !defined (__GIMP_H_INSIDE__) && !defined (GIMP_COMPILATION)
#error "Only <libgimp/gimp.h> can be included directly."
#endif

#ifndef __GIMP_ITEM_PDB_H__
#define __GIMP_ITEM_PDB_H__

G_BEGIN_DECLS

/* For information look into the C source or the html documentation */


gboolean      gimp_item_id_is_valid         (gint                item_id);
gboolean      gimp_item_id_is_drawable      (gint                item_id);
gboolean      gimp_item_id_is_layer         (gint                item_id);
gboolean      gimp_item_id_is_text_layer    (gint                item_id);
gboolean      gimp_item_id_is_vector_layer  (gint                item_id);
gboolean      gimp_item_id_is_group_layer   (gint                item_id);
gboolean      gimp_item_id_is_link_layer    (gint                item_id);
gboolean      gimp_item_id_is_channel       (gint                item_id);
gboolean      gimp_item_id_is_layer_mask    (gint                item_id);
gboolean      gimp_item_id_is_path          (gint                item_id);
gboolean      gimp_item_id_is_selection     (gint                item_id);
GimpImage*    gimp_item_get_image           (GimpItem           *item);
gboolean      gimp_item_delete              (GimpItem           *item);
gboolean      gimp_item_is_group            (GimpItem           *item);
GimpItem*     gimp_item_get_parent          (GimpItem           *item);
GimpItem**    gimp_item_get_children        (GimpItem           *item);
gboolean      gimp_item_get_expanded        (GimpItem           *item);
gboolean      gimp_item_set_expanded        (GimpItem           *item,
                                             gboolean            expanded);
gchar*        gimp_item_get_name            (GimpItem           *item);
gboolean      gimp_item_set_name            (GimpItem           *item,
                                             const gchar        *name);
gboolean      gimp_item_get_visible         (GimpItem           *item);
gboolean      gimp_item_set_visible         (GimpItem           *item,
                                             gboolean            visible);
gboolean      gimp_item_get_lock_content    (GimpItem           *item);
gboolean      gimp_item_set_lock_content    (GimpItem           *item,
                                             gboolean            lock_content);
gboolean      gimp_item_get_lock_position   (GimpItem           *item);
gboolean      gimp_item_set_lock_position   (GimpItem           *item,
                                             gboolean            lock_position);
gboolean      gimp_item_get_lock_visibility (GimpItem           *item);
gboolean      gimp_item_set_lock_visibility (GimpItem           *item,
                                             gboolean            lock_visibility);
GimpColorTag  gimp_item_get_color_tag       (GimpItem           *item);
gboolean      gimp_item_set_color_tag       (GimpItem           *item,
                                             GimpColorTag        color_tag);
guint         gimp_item_get_tattoo          (GimpItem           *item);
gboolean      gimp_item_set_tattoo          (GimpItem           *item,
                                             guint               tattoo);
gboolean      gimp_item_attach_parasite     (GimpItem           *item,
                                             const GimpParasite *parasite);
gboolean      gimp_item_detach_parasite     (GimpItem           *item,
                                             const gchar        *name);
GimpParasite* gimp_item_get_parasite        (GimpItem           *item,
                                             const gchar        *name);
gchar**       gimp_item_get_parasite_list   (GimpItem           *item);
gboolean      gimp_items_popup              (const gchar        *callback,
                                             const gchar        *popup_title,
                                             const gchar        *item_type,
                                             GimpItem           *initial_item,
                                             GBytes             *parent_window);
gboolean      gimp_items_close_popup        (const gchar        *callback);
gboolean      gimp_items_set_popup          (const gchar        *callback,
                                             GimpItem           *item);


G_END_DECLS

#endif /* __GIMP_ITEM_PDB_H__ */
