%feature("docstring") OT::PointWithDescription
R"RAW(Collection of real values with a description for each component.

Available constructors:
    PointWithDescription(*size=0, value=0.0*)

    PointWithDescription(*sequence*)

Parameters
----------
size : int, :math:`size \geq 0`
    Size of the vector.
value : float
    Value set to the *size* elements.
sequence : sequence of pair (string, float)
    Components of the vector.

Examples
--------
>>> import openturns as ot

Use the first constructor:

>>> print(ot.PointWithDescription(2))
[ : 0,  : 0]
>>> vector = ot.PointWithDescription(2, 3.0)
>>> print(vector)
[ : 3,  : 3]
>>> vector.setDescription(['c1', 'c2'])
>>> print(vector)
[c1 : 3, c2 : 3]

Use the second constructor:

>>> vector = ot.PointWithDescription([('C1', 2.0), ('C2', 3.0), ('C3', 4.5)])
>>> print(vector)
[C1 : 2, C2 : 3, C3 : 4.5]
>>> print(vector.getDescription())
[C1,C2,C3]

Use some functionalities:

>>> vector[1] = 7.1
>>> print(vector)
[C1 : 2, C2 : 7.1, C3 : 4.5]
>>> vector.add(6.2)
>>> print(vector)
[C1 : 2, C2 : 7.1, C3 : 4.5,  : 6.2])RAW"
