// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <avtMatSpeciesMetaData.h>
#include <DataNode.h>

// ****************************************************************************
// Method: avtMatSpeciesMetaData::avtMatSpeciesMetaData
//
// Purpose:
//   Init utility for the avtMatSpeciesMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void avtMatSpeciesMetaData::Init()
{
    numSpecies = 0;
    validVariable = true;

    avtMatSpeciesMetaData::SelectAll();
}

// ****************************************************************************
// Method: avtMatSpeciesMetaData::avtMatSpeciesMetaData
//
// Purpose:
//   Copy utility for the avtMatSpeciesMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void avtMatSpeciesMetaData::Copy(const avtMatSpeciesMetaData &obj)
{
    numSpecies = obj.numSpecies;
    speciesNames = obj.speciesNames;
    validVariable = obj.validVariable;

    avtMatSpeciesMetaData::SelectAll();
}

// Type map format string
const char *avtMatSpeciesMetaData::TypeMapFormatString = AVTMATSPECIESMETADATA_TMFS;
const AttributeGroup::private_tmfs_t avtMatSpeciesMetaData::TmfsStruct = {AVTMATSPECIESMETADATA_TMFS};


// ****************************************************************************
// Method: avtMatSpeciesMetaData::avtMatSpeciesMetaData
//
// Purpose:
//   Default constructor for the avtMatSpeciesMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

avtMatSpeciesMetaData::avtMatSpeciesMetaData() :
    AttributeSubject(avtMatSpeciesMetaData::TypeMapFormatString)
{
    avtMatSpeciesMetaData::Init();
}

// ****************************************************************************
// Method: avtMatSpeciesMetaData::avtMatSpeciesMetaData
//
// Purpose:
//   Constructor for the derived classes of avtMatSpeciesMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

avtMatSpeciesMetaData::avtMatSpeciesMetaData(private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    avtMatSpeciesMetaData::Init();
}

// ****************************************************************************
// Method: avtMatSpeciesMetaData::avtMatSpeciesMetaData
//
// Purpose:
//   Copy constructor for the avtMatSpeciesMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

avtMatSpeciesMetaData::avtMatSpeciesMetaData(const avtMatSpeciesMetaData &obj) :
    AttributeSubject(avtMatSpeciesMetaData::TypeMapFormatString)
{
    avtMatSpeciesMetaData::Copy(obj);
}

// ****************************************************************************
// Method: avtMatSpeciesMetaData::avtMatSpeciesMetaData
//
// Purpose:
//   Copy constructor for derived classes of the avtMatSpeciesMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

avtMatSpeciesMetaData::avtMatSpeciesMetaData(const avtMatSpeciesMetaData &obj, private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    avtMatSpeciesMetaData::Copy(obj);
}

// ****************************************************************************
// Method: avtMatSpeciesMetaData::~avtMatSpeciesMetaData
//
// Purpose:
//   Destructor for the avtMatSpeciesMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

avtMatSpeciesMetaData::~avtMatSpeciesMetaData()
{
    // nothing here
}

// ****************************************************************************
// Method: avtMatSpeciesMetaData::operator =
//
// Purpose:
//   Assignment operator for the avtMatSpeciesMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

avtMatSpeciesMetaData&
avtMatSpeciesMetaData::operator = (const avtMatSpeciesMetaData &obj)
{
    if (this == &obj) return *this;

    avtMatSpeciesMetaData::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: avtMatSpeciesMetaData::operator ==
//
// Purpose:
//   Comparison operator == for the avtMatSpeciesMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
avtMatSpeciesMetaData::operator == (const avtMatSpeciesMetaData &obj) const
{
    // Create the return value
    return ((numSpecies == obj.numSpecies) &&
            (speciesNames == obj.speciesNames) &&
            (validVariable == obj.validVariable));
}

// ****************************************************************************
// Method: avtMatSpeciesMetaData::operator !=
//
// Purpose:
//   Comparison operator != for the avtMatSpeciesMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
avtMatSpeciesMetaData::operator != (const avtMatSpeciesMetaData &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: avtMatSpeciesMetaData::TypeName
//
// Purpose:
//   Type name method for the avtMatSpeciesMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

const std::string
avtMatSpeciesMetaData::TypeName() const
{
    return "avtMatSpeciesMetaData";
}

// ****************************************************************************
// Method: avtMatSpeciesMetaData::CopyAttributes
//
// Purpose:
//   CopyAttributes method for the avtMatSpeciesMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
avtMatSpeciesMetaData::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const avtMatSpeciesMetaData *tmp = (const avtMatSpeciesMetaData *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: avtMatSpeciesMetaData::CreateCompatible
//
// Purpose:
//   CreateCompatible method for the avtMatSpeciesMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
avtMatSpeciesMetaData::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new avtMatSpeciesMetaData(*this);
    // Other cases could go here too.

    return retval;
}

// ****************************************************************************
// Method: avtMatSpeciesMetaData::NewInstance
//
// Purpose:
//   NewInstance method for the avtMatSpeciesMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
avtMatSpeciesMetaData::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new avtMatSpeciesMetaData(*this);
    else
        retval = new avtMatSpeciesMetaData;

    return retval;
}

// ****************************************************************************
// Method: avtMatSpeciesMetaData::SelectAll
//
// Purpose:
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
avtMatSpeciesMetaData::SelectAll()
{
    Select(ID_numSpecies,    (void *)&numSpecies);
    Select(ID_speciesNames,  (void *)&speciesNames);
    Select(ID_validVariable, (void *)&validVariable);
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: avtMatSpeciesMetaData::GetFieldName
//
// Purpose:
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
avtMatSpeciesMetaData::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_numSpecies:    return "numSpecies";
    case ID_speciesNames:  return "speciesNames";
    case ID_validVariable: return "validVariable";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: avtMatSpeciesMetaData::GetFieldType
//
// Purpose:
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeGroup::FieldType
avtMatSpeciesMetaData::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_numSpecies:    return FieldType_int;
    case ID_speciesNames:  return FieldType_stringVector;
    case ID_validVariable: return FieldType_bool;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: avtMatSpeciesMetaData::GetFieldTypeName
//
// Purpose:
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
avtMatSpeciesMetaData::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_numSpecies:    return "int";
    case ID_speciesNames:  return "stringVector";
    case ID_validVariable: return "bool";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: avtMatSpeciesMetaData::FieldsEqual
//
// Purpose:
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
avtMatSpeciesMetaData::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const avtMatSpeciesMetaData &obj = *((const avtMatSpeciesMetaData*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_numSpecies:
        {  // new scope
        retval = (numSpecies == obj.numSpecies);
        }
        break;
    case ID_speciesNames:
        {  // new scope
        retval = (speciesNames == obj.speciesNames);
        }
        break;
    case ID_validVariable:
        {  // new scope
        retval = (validVariable == obj.validVariable);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
//  Method: avtMatSpeciesMetaData constructor
//
//  Arguments:
//      ns           The number of species for this material.
//      sn           The name of each species for this material.
//
//  Programmer: Jeremy Meredith
//  Creation:   December 13, 2001
//
//  Modifications:
//
//    Hank Childs, Mon Dec  9 17:04:39 PST 2002
//    Initialized validVariable.
//
// ****************************************************************************

avtMatSpeciesMetaData::avtMatSpeciesMetaData(int ns, const stringVector &sn)
    : AttributeSubject(avtMatSpeciesMetaData::TypeMapFormatString)
{
    numSpecies    = ns;
    speciesNames  = sn;
    validVariable = true;
}

