// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                             avtXmdvWriter.h                               //
// ************************************************************************* //

#ifndef AVT_Xmdv_WRITER_H
#define AVT_Xmdv_WRITER_H

#include <avtDatabaseWriter.h>

#include <visitstream.h>

#include <string>
#include <vector>

class DBOptionsAttributes;


// ****************************************************************************
//  Class: avtXmdvWriter
//
//  Purpose:
//      A module that writes out Xmdv files.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Tue Jul 19 17:12:44 PST 2005
//
//  Modifications:
//
//    Hank Childs, Tue Sep 27 10:21:36 PDT 2005
//    Use virtual inheritance.
//
//    Jeremy Meredith, Tue Mar 27 15:10:21 EDT 2007
//    Added nblocks to OpenFile and save it so we don't have to 
//    trust the meta data.
//
//    Kathleen Bonnell, Mon Apr 16 11:38:34 PDT 2007 
//    Add varCentering.
//
// ****************************************************************************

class
avtXmdvWriter : virtual public avtDatabaseWriter
{
  public:
                   avtXmdvWriter(DBOptionsAttributes *);
    virtual       ~avtXmdvWriter() {;};

  protected:
    std::string    stem;
    bool           onlyOneBlock;
    std::vector<std::string> scalars;
    std::vector<std::string> vectors;
    bool           varsAreNodal;
    avtCentering   varCentering;
    bool           writeOutCoordinates;
    int            nblocks;

    virtual void   OpenFile(const std::string &, int);
    virtual void   WriteHeaders(const avtDatabaseMetaData *,
                                const std::vector<std::string> &, 
                                const std::vector<std::string> &,
                                const std::vector<std::string> &);
    virtual void   WriteChunk(vtkDataSet *, int);
    virtual void   CloseFile(void);
    virtual void   WriteRootFile();
};


#endif
