# Release History

## 2.0.0b1 (2025-10-27)

### Breaking Changes

* Authoring functionality (project creation, knowledge source management, deployment operations) has been removed from this package and moved to a separate dedicated authoring package / namespace. All references to `AuthoringClient`, and related authoring operations have been eliminated from the runtime client distribution.
* Dropped support for Python versions earlier than 3.9 (aligns with Azure SDK Python support policy going forward).
* Model base class change: all public model types now inherit from `MutableMapping[str, Any]` (dict-like) instead of the previous `Model` base class. As a result they now support standard mutable mapping behavior (key iteration, item assignment, etc.) and any code depending on methods/properties inherited from the old base class should be reviewed/updated.
* Removed client constructor keyword argument `default_language`. Per-call language control is now done explicitly via the `language` property on `AnswersFromTextOptions` (and related options models). The service default remains `"en"` if a language is not supplied. To change the effective language:
  * Pass `language="<bcp-47-code>"` when constructing `AnswersFromTextOptions` (e.g. `"es"`, `"zh-Hans"`).
  * Or create / select a project in the desired language in [Language Studio](https://language.azure.com) when authoring knowledge bases.

  The previous implicit fallback (client-level `default_language`) has been removed to avoid hidden state and to encourage explicit specification or project-level configuration.
* Removed support for passing metadata as `Dict[str,str]` to `MetadataFilter`. Tuple form `[("key","value"), ...]` and `List[MetadataRecord]` remain supported.

### Features Added

* Documentation improvements: expanded README with authentication guidance, AAD usage, async examples, and troubleshooting section.

### Other Changes

* Internal refactoring and dependency grooming in preparation for the authoring/runtime split.
* Changed samples and README examples to use explicit `AnswersOptions` / `AnswersFromTextOptions` objects as the first argument when calling `get_answers` and `get_answers_from_text`.

## 1.1.0 (2022-10-13)

### Breaking Changes
> These changes do not impact the API of stable versions such as 1.0.0.
> Only code written against a beta version such as 1.1.0b2 may be affected

* `QuestionAnsweringProjectsClient` was renamed to `AuthoringClient`.
* The `azure.ai.language.questionanswering.projects` namespace was renamed to `azure.ai.language.questionanswering.authoring`
* Authoring client methods: `begin_deploy_project`, `begin_import_assets`, `begin_update_sources` 
  and `begin_update_qnas` now return a response upon completion of the long-running operation.
* Keyword argument `format` renamed to `file_format` for `begin_export` and `begin_import_assets`.

### Bugs Fixed
* Fixed a bug where the client-level keyword argument `default_language` was not being honored for `get_answers_from_text`.

### Other Changes
* Python 3.6 is no longer supported. Please use Python version 3.7 or later. For more details, see [Azure SDK for Python version support policy](https://github.com/Azure/azure-sdk-for-python/wiki/Azure-SDKs-Python-version-support-policy).
* Dropped dependency on `msrest`.

## 1.1.0b2 (2022-07-19)

### Features Added
* Added Azure Active Directory (AAD) authentication support

### Other Changes
* Python 2.7 is no longer supported. Please use Python version 3.6 or later.

## 1.1.0b1 (2022-02-08)

### Features Added
* Added `QuestionAnsweringProjectsClient` for managing Qna projects. Performing project operations such as create, delete, export, and import project, as well as knowledge sources operations such as adding or listing knowledge sources, Qnas, and synonyms.

## 1.0.0 (2021-11-03)

* We are now targeting service version `2021-10-01`

### Breaking Changes

* Method `QuestionAnsweringClient.query_knowledge_base` has been renamed to `get_answers`
* Method `QuestionAnsweringClient.query_text` has been renamed to `get_answers_from_text`
* Model `QueryKnowledgeBaseOptions` has been renamed to `AnswersOptions`
* Method kwarg and model property `QueryKnowledgeBaseOptions.confidence_score_threshold` has been renamed to  `AnswersOptions.confidence_threshold`
* Method kwarg and model property `QueryKnowledgeBaseOptions.answer_span_request` has been renamed to  `AnswersOptions.short_answer_options`
* Method kwarg and model property `QueryKnowledgeBaseOptions.ranker_type` has been renamed to  `AnswersOptions.ranker_kind`
* Method kwarg and model property `QueryKnowledgeBaseOptions.context` has been renamed to  `AnswersOptions.answer_context`
* Model `QueryTextOptions` has been renamed to `AnswersFromTextOptions`
* Method kwarg and model property `QueryTextOptions.records` has been renamed to `AnswersFromTextOptions.text_documents`
* Model `AnswerSpanRequest` has been renamed to `ShortAnswerOptions`
* Model property `AnswerSpanRequest.confidence_score_threshold` has been renamed to `ShortAnswerOptions.confidence_threshold`
* Model property `AnswerSpanRequest.top_answers_with_span` has been renamed to `ShortAnswerOptions.top`
* Model `KnowledgeBaseAnswerRequestContext` has been renamed to `KnowledgeBaseAnswerContext`
* Model property `KnowledgeBaseAnswerRequestContext.previous_user_query` has been renamed to `KnowledgeBaseAnswerContext.previous_question`
* Model `TextRecord` has been renamed to `TextDocument`
* Model `KnowledgeBaseAnswers` has been renamed to `AnswersResult`
* Model `TextAnswers` has been renamed to `AnswersFromTextResult`
* Model property `KnowledgeBaseAnswer.answer_span` has been renamed to `KnowledgeBaseAnswer.short_answer`
* Model property `KnowledgeBaseAnswer.id` has been renamed to `KnowledgeBaseAnswer.qna_id`
* Model property `KnowledgeBaseAnswer.confidence_score` has been renamed to `KnowledgeBaseAnswer.confidence`
* Model property `AnswerSpan.confidence_score` has been renamed to `AnswerSpan.confidence`
* Model property `TextAnswer.confidence_score` has been renamed to `TextAnswer.confidence`
* Model property `TextAnswer.answer_span` has been renamed to `TextAnswer.short_answer`
* Enums `LogicalOperationKind` and `RankerType` have been removed
* The `operations` and `aio.operations` namespaces are no longer public

### Bugs Fixed

* Fixed formating of `MetadataFilter.metadata`

## 1.0.0b2 (2021-10-06)

* We are now targeting service version `2021-07-15-preview`

### Breaking changes

* The method `QuestionAnsweringClient.query_knowledgebase` has been renamed to `query_knowledge_base`.
* Options bag model `KnowledgeBaseQueryOptions` for `query_knowledge_base` is renamed to `QueryKnowledgeBaseOptions`
* Options bag model `TextQueryOptions` for `query_text` is renamed to `QueryTextOptions`
* The filters model `StrictFilters` is renamed to `QueryFilters`
* Enum `CompoundOperationKind` is renamed to `LogicalOperationKind`
* We have removed the `string_index_type` input to all models and operations. We have also removed the `StringIndexType` enum.
* The type of input `metadata` to `MetadataFilter` has changed from a dictionary of strings to a list of key-value tuples. For example, the input has changed from `{"key": "value"}` to `[("key", "value")]`.
* The input to the `query_knowledge_base` and `query_text` overloads that take in a positional model for the body should be considered positional only.

### Features Added

* The method `QuestionAnsweringClient.query_text` now supports a list of records as strings, where the ID value will be automatically populated.
* Added keyword argument `default_language` onto `QuestionAnsweringClient`, which has default value `'en'`. The default language for any operation call will be this default language value.


## 1.0.0b1 (2021-07-27)

### Features Added
* Initial release - supports querying from text records and knowledge bases.