% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{getTables}
\alias{getTables}
\title{List Excel tables in a workbook}
\usage{
getTables(wb, sheet)
}
\arguments{
\item{wb}{A workbook object}

\item{sheet}{A name or index of a worksheet}
}
\value{
character vector of table names on the specified sheet
}
\description{
List Excel tables in a workbook
}
\examples{

wb <- createWorkbook()
addWorksheet(wb, sheetName = "Sheet 1")
writeDataTable(wb, sheet = "Sheet 1", x = iris)
writeDataTable(wb, sheet = 1, x = mtcars, tableName = "mtcars", startCol = 10)

getTables(wb, sheet = "Sheet 1")
}
