// Copyright (c) 2022 Advanced Micro Devices, Inc. All rights reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

#include <fstream>
#include <iomanip>
#include <iostream>
#include <random>
#include <string>

using namespace std;

template<typename DirectionVectorType>
void write_constants(std::ofstream&    fout,
                     const std::string name,
                     int32_t           n,
                     int32_t           numbers_per_line)
{
    fout << "static const ";
    fout << ((sizeof(DirectionVectorType) == 4) ? "unsigned int " : "unsigned long long int ");
    fout << name << "[SCRAMBLED_SOBOL_DIM] = {" << std::endl;
    fout << "    ";

    std::mt19937                                       gen;
    std::uniform_int_distribution<DirectionVectorType> dis;

    for(int k = 0; k < n; k++)
    {
        fout << "0x";
        fout << std::hex << std::setw(sizeof(DirectionVectorType) * 2) << std::setfill('0')
             << dis(gen) << ",";
        if((k + 1) % numbers_per_line == 0 && k != (n - 1))
            fout << std::endl << "    ";
        else if(k != (n - 1))
            fout << " ";
    }
    fout << std::endl << std::endl;
    fout << "};" << std::endl;
}

int main(int argc, char const* argv[])
{
    if(argc != 2 || std::string(argv[1]) == "--help")
    {
        std::cout << "Usage:" << std::endl;
        std::cout << "  ./scrambled_sobol64_direction_constants_generator "
                     "../../library/include/rocrand/rocrand_scrambled_sobol64_constants.h"
                  << std::endl;
        return -1;
    }

    const unsigned int SCRAMBLED_SOBOL_DIM = 20000;

    const std::string file_path(argv[1]);
    std::ofstream     fout(file_path, std::ios_base::out | std::ios_base::trunc);

    fout << R"(// Copyright (c) 2022 Advanced Micro Devices, Inc. All rights reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

#ifndef ROCRAND_SCRAMBLED_SOBOL64_CONSTANTS_H_
#define ROCRAND_SCRAMBLED_SOBOL64_CONSTANTS_H_

// Auto-generated file. Do not edit!
// Generated by tools/scrambled_sobol64_constants_generator

)";

    fout << "#ifndef SCRAMBLED_SOBOL_DIM" << std::endl;
    fout << "    #define SCRAMBLED_SOBOL_DIM " << SCRAMBLED_SOBOL_DIM << std::endl;
    fout << "#endif" << std::endl;
    fout << std::endl;

    write_constants<uint64_t>(fout, "h_scrambled_sobol64_constants", SCRAMBLED_SOBOL_DIM, 4);

    fout << R"(
#endif // ROCRAND_SCRAMBLED_SOBOL64_CONSTANTS_H_
)";

    return 0;
}
