# \MapApi

All URIs are relative to *https://api.transitous.org*

Method | HTTP request | Description
------------- | ------------- | -------------
[**initial**](MapApi.md#initial) | **GET** /api/v1/map/initial | initial location to view the map at after loading based on where public transport should be visible
[**levels**](MapApi.md#levels) | **GET** /api/v1/map/levels | Get all available levels for a map section
[**rentals**](MapApi.md#rentals) | **GET** /api/v1/rentals | Get a list of rental providers or all rental stations and vehicles for a map section or provider 
[**stops**](MapApi.md#stops) | **GET** /api/v1/map/stops | Get all stops for a map section
[**trips**](MapApi.md#trips) | **GET** /api/v5/map/trips | Given a area frame (box defined by top right and bottom left corner) and a time frame, it returns all trips and their respective shapes that operate in this area + time frame. Trips are filtered by zoom level. On low zoom levels, only long distance trains will be shown while on high zoom levels, also metros, buses and trams will be returned. 



## initial

> models::Initial200Response initial()
initial location to view the map at after loading based on where public transport should be visible

### Parameters

This endpoint does not need any parameter.

### Return type

[**models::Initial200Response**](initial_200_response.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## levels

> Vec<f64> levels(min, max)
Get all available levels for a map section

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**min** | **String** | latitude,longitude pair of the lower right coordinate | [required] |
**max** | **String** | latitude,longitude pair of the upper left coordinate | [required] |

### Return type

**Vec<f64>**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## rentals

> models::Rentals200Response rentals(min, max, provider_groups, providers, with_providers, with_stations, with_vehicles, with_zones)
Get a list of rental providers or all rental stations and vehicles for a map section or provider 

If neither the map section (`min` and `max`) nor a provider filter (either `providerGroups` or `providers`) is provided, returns a list of all available rental providers, but no station, vehicle or zone data. Provide the `withProviders=false` parameter to retrieve only provider groups if detailed feed information is not required.  Either the map section (`min` and `max`) or the provider filter (either `providerGroups` or `providers`) must be provided to retrieve station, vehicle and zone data.  If only the map section is provided, all data in the area is returned. If only the provider filter is provided, all data for the given providers is returned. If both parameters are provided, only data for the given providers in the map section is returned. 

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**min** | Option<**String**> | latitude,longitude pair of the lower right coordinate |  |
**max** | Option<**String**> | latitude,longitude pair of the upper left coordinate |  |
**provider_groups** | Option<[**Vec<String>**](String.md)> | A list of rental provider groups to return. If both `providerGroups` and `providers` are empty/not specified, all providers in the map section are returned.  |  |
**providers** | Option<[**Vec<String>**](String.md)> | A list of rental providers to return. If both `providerGroups` and `providers` are empty/not specified, all providers in the map section are returned.  |  |
**with_providers** | Option<**bool**> | Optional. Include providers in output. If false, only provider groups are returned.  Also affects the providers list for each provider group.  |  |[default to true]
**with_stations** | Option<**bool**> | Optional. Include stations in output (requires at least min+max or providers filter). |  |[default to true]
**with_vehicles** | Option<**bool**> | Optional. Include free-floating vehicles in output (requires at least min+max or providers filter). |  |[default to true]
**with_zones** | Option<**bool**> | Optional. Include geofencing zones in output (requires at least min+max or providers filter). |  |[default to true]

### Return type

[**models::Rentals200Response**](rentals_200_response.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## stops

> Vec<models::Place> stops(min, max)
Get all stops for a map section

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**min** | **String** | latitude,longitude pair of the lower right coordinate | [required] |
**max** | **String** | latitude,longitude pair of the upper left coordinate | [required] |

### Return type

[**Vec<models::Place>**](Place.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## trips

> Vec<models::TripSegment> trips(zoom, min, max, start_time, end_time)
Given a area frame (box defined by top right and bottom left corner) and a time frame, it returns all trips and their respective shapes that operate in this area + time frame. Trips are filtered by zoom level. On low zoom levels, only long distance trains will be shown while on high zoom levels, also metros, buses and trams will be returned. 

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**zoom** | **f64** | current zoom level | [required] |
**min** | **String** | latitude,longitude pair of the lower right coordinate | [required] |
**max** | **String** | latitude,longitude pair of the upper left coordinate | [required] |
**start_time** | **String** | start of the time window | [required] |
**end_time** | **String** | end if the time window | [required] |

### Return type

[**Vec<models::TripSegment>**](TripSegment.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

