package ONVIF::Media::Types::NetworkZeroConfiguration;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %InterfaceToken_of :ATTR(:get<InterfaceToken>);
my %Enabled_of :ATTR(:get<Enabled>);
my %Addresses_of :ATTR(:get<Addresses>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        InterfaceToken
        Enabled
        Addresses
        Extension

    ) ],
    {
        'InterfaceToken' => \%InterfaceToken_of,
        'Enabled' => \%Enabled_of,
        'Addresses' => \%Addresses_of,
        'Extension' => \%Extension_of,
    },
    {
        'InterfaceToken' => 'ONVIF::Media::Types::ReferenceToken',
        'Enabled' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        'Addresses' => 'ONVIF::Media::Types::IPv4Address',
        'Extension' => 'ONVIF::Media::Types::NetworkZeroConfigurationExtension',
    },
    {

        'InterfaceToken' => 'InterfaceToken',
        'Enabled' => 'Enabled',
        'Addresses' => 'Addresses',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Media::Types::NetworkZeroConfiguration

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
NetworkZeroConfiguration from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * InterfaceToken


=item * Enabled


=item * Addresses


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Media::Types::NetworkZeroConfiguration
   InterfaceToken => $some_value, # ReferenceToken
   Enabled =>  $some_value, # boolean
   Addresses => $some_value, # IPv4Address
   Extension =>  { # ONVIF::Media::Types::NetworkZeroConfigurationExtension
     Extension =>  { # ONVIF::Media::Types::NetworkZeroConfigurationExtension2
     },
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

