import dataclasses
from typing import Generic, Optional, Type, List

from debputy.util import T

ALL_DEBPUTY_CONFIG_OPTIONS: List["DebputyConfigOption"] = []


@dataclasses.dataclass(slots=True, frozen=True)
class DebputyConfigOption(Generic[T]):
    config_name: str
    value_type: Type[T]
    default_value: Optional[T] = None

    def __post_init__(self) -> None:
        ALL_DEBPUTY_CONFIG_OPTIONS.append(self)


DCO_SPELLCHECK_COMMENTS = DebputyConfigOption(
    "diagnostics.spellchecking.spellcheck-comments",
    bool,
    default_value=True,
)
