import * as Ot from "@ot-builder/ot";
export type ShareGlyphSetOptions = {
    unifyGlyphList?: boolean;
};
export declare class GlyphSharer<GS extends Ot.GlyphStore> {
    private readonly gsf;
    constructor(gsf: Ot.GlyphStoreFactory<GS>);
    private readonly session;
    private readonly sharedGs;
    fonts: Ot.Font<GS>[];
    fontUnificationResults: GlyphUnificationResults[];
    addFont(inputFont: Ot.Font<GS>): void;
    unifyGlyphList(): void;
    getGlyphList(): Ot.Glyph[];
}
export declare function shareGlyphSet<GS extends Ot.GlyphStore>(fonts: Ot.Font<GS>[], gsf: Ot.GlyphStoreFactory<GS>, options?: ShareGlyphSetOptions): void;
export type GlyphUnificationResults = {
    originalNames: WeakMap<Ot.Glyph, string>;
};
//# sourceMappingURL=share-glyph-set.d.ts.map