"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetricBasicIo = void 0;
const bin_util_1 = require("@ot-builder/bin-util");
const errors_1 = require("@ot-builder/errors");
const ot_glyphs_1 = require("@ot-builder/ot-glyphs");
exports.MetricBasicIo = {
    ...(0, bin_util_1.Read)((view, hea, maxp) => {
        const table = new ot_glyphs_1.MetricBasic.Table();
        let lastAdvance = 0;
        for (let gid = 0; gid < maxp.numGlyphs; gid++) {
            const m = new ot_glyphs_1.MetricBasic.Measure();
            if (gid < hea.numberOfLongMetrics) {
                m.advance = view.uint16();
                m.startSideBearing = view.int16();
            }
            else {
                m.advance = lastAdvance;
                m.startSideBearing = view.int16();
            }
            table.measures[gid] = m;
            lastAdvance = m.advance;
        }
        return table;
    }),
    ...(0, bin_util_1.Write)((frag, mtx, hea, gord) => {
        if (gord.length !== mtx.measures.length) {
            throw errors_1.Errors.GlyphCountMismatch(`metric-static table writing`);
        }
        for (let gid = 0; gid < mtx.measures.length; gid++) {
            const measure = mtx.measures[gid];
            if (gid < hea.numberOfLongMetrics) {
                frag.uint16(measure.advance);
                frag.int16(measure.startSideBearing);
            }
            else {
                frag.int16(measure.startSideBearing);
            }
        }
    })
};
//# sourceMappingURL=metric-basic.js.map