/* foundry-path.h
 *
 * Copyright 2024 Christian Hergert <chergert@redhat.com>
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of the
 * License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#pragma once

#include <libdex.h>

#include "foundry-version-macros.h"

G_BEGIN_DECLS

FOUNDRY_AVAILABLE_IN_ALL
char      *foundry_path_expand        (const char *path);
FOUNDRY_AVAILABLE_IN_ALL
char      *foundry_path_collapse      (const char *path);
FOUNDRY_DEPRECATED_IN_1_1_FOR(dex_mkdir_with_parents)
DexFuture *foundry_mkdir_with_parents (const char *path,
                                       int         mode) G_GNUC_WARN_UNUSED_RESULT;

#ifndef __GI_SCANNER__

static inline void
foundry_path_expand_inplace (char **ptr)
{
  char *tmp = *ptr;
  *ptr = foundry_path_expand (tmp);
  g_free (tmp);
}

#endif

G_END_DECLS
