# File: makefile.defs.linux.pulse_static.BE

# System: Linux
# David Weenink and Paul Boersma, 29 December 2025

# statically linked with the standard C and C++ libraries,
# hence avoiding `gethostbyname` by defining NO_NETWORK

CC ?= gcc
CXX ?= g++
LINK ?= $(CXX)

PKG_CONFIG ?= "pkg-config"

COMMONFLAGS = -DNO_NETWORK -DUNIX -Dlinux -DALSA -DHAVE_PULSEAUDIO -D_FILE_OFFSET_BITS=64 `$(PKG_CONFIG) --cflags gtk+-3.0` \
	-DWORDS_BIGENDIAN=1 -DPA_BIG_ENDIAN \
	-Wreturn-type -Wunused -Wunused-parameter -Wuninitialized -O3 -g1 -pthread

CFLAGS = -std=gnu99 $(COMMONFLAGS) -Werror=missing-prototypes -Werror=implicit

CXXFLAGS = -std=c++17 $(COMMONFLAGS) -Wshadow

EXECUTABLE = praat_static

LIBS = `$(PKG_CONFIG) --libs gtk+-3.0` -no-pie -lm -lpulse -lasound -static-libgcc -static-libstdc++ -lpthread -L /usr/lib/x86_64-linux-gnu

AR = ar
RANLIB = ls
ICON =
MAIN_ICON =

INSTALL = install -p praat /usr/local/bin
