% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_content.R
\name{as_paragraph}
\alias{as_paragraph}
\title{Build a paragraph from chunks}
\usage{
as_paragraph(..., list_values = NULL)
}
\arguments{
\item{...}{chunk elements that are defining the paragraph content.
If a character is used, it is transformed to a chunk object with
function \code{\link[=as_chunk]{as_chunk()}}.}

\item{list_values}{a list of chunk elements that are defining
the paragraph content. If specified argument \code{...} is unused.}
}
\description{
\code{as_paragraph()} assembles one or more chunks into a single paragraph
that defines the content of a flextable cell. Each cell in a flextable
contains exactly one paragraph; a paragraph is an ordered sequence of
chunks.

Chunks are the smallest content units and can be created with
\code{\link[=as_chunk]{as_chunk()}} (formatted text), \code{\link[=as_b]{as_b()}} / \code{\link[=as_i]{as_i()}} (bold / italic
shortcuts), \code{\link[=minibar]{minibar()}} (inline bar), \code{\link[=as_image]{as_image()}} (image),
\code{\link[=gg_chunk]{gg_chunk()}} (ggplot), \code{\link[=as_equation]{as_equation()}} (equation) or
\code{\link[=hyperlink_text]{hyperlink_text()}} (link). Plain character strings passed to
\code{as_paragraph()} are automatically converted to chunks via
\code{\link[=as_chunk]{as_chunk()}}.

The resulting paragraph is passed to the \code{value} argument of
\code{\link[=compose]{compose()}}, \code{\link[=mk_par]{mk_par()}}, \code{\link[=add_header_lines]{add_header_lines()}},
\code{\link[=add_footer_lines]{add_footer_lines()}} or \code{\link[=footnote]{footnote()}} to set cell content.
}
\examples{
library(flextable)
ft <- flextable(airquality[sample.int(150, size = 10), ])
ft <- compose(ft,
  j = "Wind",
  value = as_paragraph(
    as_chunk(Wind, props = fp_text_default(color = "orange")),
    " ",
    minibar(value = Wind, max = max(airquality$Wind), barcol = "orange", bg = "black", height = .15)
  ),
  part = "body"
)
ft <- autofit(ft)
ft
}
\seealso{
\code{\link[=as_chunk]{as_chunk()}}, \code{\link[=minibar]{minibar()}},
\code{\link[=as_image]{as_image()}}, \code{\link[=hyperlink_text]{hyperlink_text()}}

Other functions for mixed content paragraphs: 
\code{\link{append_chunks}()},
\code{\link{compose}()},
\code{\link{prepend_chunks}()}
}
\concept{functions for mixed content paragraphs}
