# Introduction {#introduction}

Robot Raconteur(R) is an Apache-2.0 licensed open-source communication library designed to ease the integration of complex automation systems that are composed of disparate components that run within different processes on a computer, are distributed over a network, or are embedded devices.  These components are often produced by different vendors with completely different interfaces that may not run on the same platforms and are frequently mutually exclusive in terms of the API provided for the user of the component.  Add in that most modern systems are distributed over a network and the result is a long, often frustrating development cycle to produce a front-end that is capable of controlling all of the elements in a high-level user friendly manner.  For modern laboratory or prototype systems this usually means producing a MATLAB, Python, or LabView front end that can be scripted.  After the prototype is completed a high-level interface may be developed in a language like C++.  Robot Raconteur is designed specifically to ease this design process and adds a number of additional capabilities that would otherwise be time consuming to implement.

Robot Raconteur provides a language, platform, and technology neutral augmented object-oriented communication system that provides the ability for a *client* to rapidly access functionality exposed by a *service* either within the same computer, over a network, or over a connection technology such as USB.  Robot Raconteur is built around the idea of a *Service* exposing *Objects* to a client. This is accomplished by registering a *root object* as a service within a Robot Raconteur *Node* that acts as the server.  Object *Members* consist of the contents of the object, and are typically *functions*, *properties*, and *events*. (In C++, Python, and Java these are made by using helper classes like Boost or JavaBeans.)  Robot Raconteur uses an *augmented object-oriented* model that has a number of member types: properties, functions, events, objrefs, pipes, callbacks, wires, and memories. The specific function of these members are discussed in \ref object-members. These members are mirrored to *Object References* (sometimes called "Proxy Objects") in a client Robot Raconteur *Node*.  These references mirror the members and allow the client to access the members of the service objects through a *Transport Connection* between the client and service node.  Figure "Client-Service Communication" shows a diagram of this configuration. Multiple clients can access the same service simultaneously as shown in Figure "Configuration of Client-Service communication with multiple clients".

![Client-Service Communication](@ref client-service.svg)

![Configuration of Client-Service communication with multiple clients](@ref client-service-multi.svg)

A node can expose more than one service.  Each service is registered with a unique name that is used as part of the URL to connect to the service.

The Robot Raconteur library contains almost all of the functionality to implement the communication between the client and service.  It has been designed to require a minimal amount of "boilerplate" coding, instead using dynamic meta-programming when possible or code-generation when necessary to produce the "thunk" code that implements the conversion between the client member reference and the real member in the service.  To the user the network layer is *almost* invisible.  Robot Raconteur uses plain-text files called *Service Definition* files to define the objects and composite data types (structures) that are used in a service.  \ref example_createinterface shows an example service definition, and \ref service_definition goes into great detail how these files are used.  A service definition is a very simple way to define the *interface* to the service objects.  The service definition provides a "lowest-common denominator" to all the languages that Robot Raconteur supports.  These service definitions are used as the input to code generation or dynamic programming (such as in Python) and can result in hundreds of thousands of lines of codes in some situations that would otherwise need to be written manually.  A very unique feature of Robot Raconteur is that it sends these service definition files at runtime when a client connects.  This means that a dynamic language like Python or MATLAB does not need any a priori information about a service; these languages can simply connect and provide a fully functional interface dynamically.  This is *extremely* powerful for prototyping and is the initial motivation for the development of Robot Raconteur.

Beyond the client-service communication, Robot Raconteur has a number of highly useful support features.  Robot Raconteur has auto-discovery, meaning that nodes can find each other based on the type of the root object service among other criteria.  Authentication is available to control access to the services on a Node.  Finally, Robot Raconteur provides exclusive object locks that allow clients to request exclusive use of objects within a service to prevent access collisions.

The core Robot Raconteur library is written in C++ using the Boost libraries and is capable of running on a number of platforms. It has minimal dependencies making it highly portable. Currently RR has been compiled and tested on Windows (x86 and x64), Linux (x86, x86\_64, ARM hard-float, ARM soft-float, PowerPC, MIPS), Mac OSX, Android (ARM, x86), and iOS.  Language bindings are used to allow access to the library from other languages. Additional supported languages include C\#, Java, Python, and MATLAB. A LabView add-on is available as a commercial product.

Two additional implementations are available for use in a web browser written in JavaScript and for use in an ASP.NET server written in pure C\#.  These implementations take advantage of the support for WebSockets over TCP to allow for compatibility with existing web infrastructure. The HTML5/Javascript implementation has been tested with Chrome, Firefox, Internet Explorer, Edge, and Safari. The pure C\# implementation has been tested with IIS and allows RR to run inside a web server. See the [https://github.com/robotraconteur/RobotRaconteurWeb](RobotRaconteurWeb) libary for more information.

Robot Raconteur communication is based on a simple message passing system with a well defined format that is simple enough that a fully functional (yet simple) service service has been implemented on an Arduino UNO (2 kB RAM, 32 kB flash) using a customized implementation of the Robot Raconteur protocol.

Robot Raconteur provides network security through TLS encryption and certificate based authentication.  See the [documentation homepage](https://github.com/robotraconteur/robotraconteur/wiki/Documentation) for more information on using TLS certificates.

## Example Robot {#example_robot}

The example robot used in this documentation is an iRobot Create that has been augmented with two webcams, a power converter, and a Raspberry Pi 3 ARM computer. Figure "Example Robot" shows a picture of the robot.  Services will be developed in this tutorial to drive the robot and access the webcams.  Clients will use the services to control the robot and read the sensors.

![Example Robot](@ref example-robot.jpg)
