---
myst:
  html_meta:
    keywords: LaTeX, composition, annexes, tables des matières,
              mini-tables, mini-table, minitoc, shorttoc
---

# Comment générer plusieurs tables des matières ?

## Avec l'extension <ctanpkg:minitoc>

L'extension <ctanpkg:minitoc> permet de créer une table des matières restreinte
pour chaque partie, chapitre ou section selon les possibilités des classes.

Son utilisation est présentée à la question : 
"[](/3_composition/annexes/tables/generer_une_table_des_matieres_par_chapitre)".


## Avec l'extension <ctanpkg:shorttoc>

L'extension <ctanpkg:shorttoc> permet de créer plusieurs tables des matières 
avec différentes profondeurs, afin par exemple d'avoir une vue plus globale 
pour un long document : elles s'obtiennent avec la commande 
`\shorttoc{⟨titre⟩}{⟨profondeur⟩}` qui permet de donner un `⟨titre⟩` 
à chaque table et de préciser la profondeur de la table (au sens du compteur
`tocdepth` évoqué à la question suivante :
"[](/3_composition/annexes/tables/changer_la_profondeur_de_la_table_des_matieres)").

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{shorttoc}

\begin{document}
\shorttoc{Au sommaire}{1}
\bigskip \bigskip
\noindent Voici de grandes questions !
\section{Qui suis-je ?}
Bonne question.
\section{Où vais-je ?}
Décidément, très bonne question.
\subsection{Dans quel état j'erre ?}
Euh...
\tableofcontents
\end{document}
```

Notez que la commande `\shorttoc` se place, dans le document,
avant la commande `\tableofcontents`.

Cette extension permet également de citer une table des matière 
d'un autre document.